const app = Vue.createApp({});

app.component("module-accordion", {
  props: {
    title: {
      type: String,
      require: true,
    },
  },
  data() {
    return {
      isShow: false,
    };
  },
  methods: {
    beforeEnter(el) {
      gsap.set(el, {
        height: 0,
        overflow: "hidden",
      });
    },
    enter(el, done) {
      gsap.to(el, {
        height: "auto",
        onComplete: done,
      });
    },
    leave(el, done) {
      gsap.to(el, {
        height: 0,
        onComplete: done,
      });
    },
  },
  template: `
    <div class="accordion">
      <dt class="accordion__term">
       <button type="button" class="button accordion__button" @click="isShow = !isShow">{{title}}</button>
      </dt>
      <transition @before-enter="beforeEnter" @enter="enter" @leave="leave">
        <dd v-show="isShow" class="accordion__body">
          <div class="accordion__contents">
            <slot></slot>
          </div>
        </dd>
      </transition>
    </div>
    `,
});

app.mount("#app");
