const app = Vue.createApp({
  data() {
    return {
      fontSize: 1,
    };
  },
  methods: {
    onChangeFontSize(value) {
      this.fontSize += value;
    },
  },
});

app.component("module-button", {
  props: {
    value: {
      type: Number,
      default: () => 1,
      require: true,
    },
  },

  template: `
    <button @click="$emit('textSize', this.value)">
      <slot></slot>
    </button>
  `,
});

app.mount("#app");
