Vue.createApp({
  data() {
    return {
      lastName: "",
      firstName: "",
      date: new Date(),
      error: "",
      lists: ["タスク1", "タスク2"],
      task: "",
    };
  },
  computed: {
    fullName() {
      return `${this.lastName} ${this.firstName}`;
    },
    computedDate() {
      return new Date();
    },
    dateFormat() {
      const weeks = ["日", "月", "火", "水", "木", "金", "土"];
      return `${this.date.getFullYear()}年${this.date.getMonth() + 1}月${this.date.getDate()}日（${
        weeks[this.date.getDay()]
      }） ${this.date.getHours()}時${this.date.getMinutes()}分${this.date.getSeconds()}秒`;
    },
  },
  methods: {
    methodDate() {
      return new Date();
    },
    addName() {
      this.lists.push(this.task);
    },
  },
  watch: {
    firstName(newName, oldName) {
      this.error = newName.length > 5 ? "5文字以内で！" : "";
    },

    lists: {
      handler(newTask, oldTask) {
        sessionStorage.setItem("lists", JSON.stringify(newTask));
      },
      deep: true,
    },
  },
}).mount("#app");
