Vue.createApp({
  data() {
    return {
      priorities: ["低", "中", "高"],
      title: "",
      description: "",
      priority: 1,
      todos: [],
      sort: "desc",
      filter: "all",
      hideDone: false,
      search: "",
    };
  },
  computed: {
    results() {
      return this.todos
        .filter((todo) => {
          console.log(this.filter);
          console.log(todo.priority);
          return this.filter === "all" ? true : todo.priority == this.filter;
        })
        .filter((todo) => {
          return this.hideDone ? !todo.done : true;
        })
        .filter((todo) => {
          return todo.title.includes(this.search) || todo.description.includes(this.search);
        })
        .sort((a, b) => {
          const dataA = new Date(a.publish);
          const dataB = new Date(b.publish);

          if (this.sort === "asc") {
            return dataA - dataB;
          }
          return dataB - dataA;
        });
    },

    dataFormat() {
      return (dateTime) => {
        const d = new Date(dateTime);
        const year = d.getFullYear();
        const month = d.getMonth() + 1;
        const date = d.getDate();
        const hour = d.getHours();
        const minute = d.getMinutes();
        const second = d.getSeconds();
        return `${year}年${month}月${date}日 ${hour}:${minute}:${second}`;
      };
    },
  },
  methods: {
    createTodo() {
      if (this.title == "") {
        return;
      }

      this.todos.push({
        id: Date.now(),
        publish: Date(),
        title: this.title,
        description: this.description,
        priority: this.priority,
        done: false,
      });

      this.title = "";
      this.description = "";
      this.priority = 1;
    },
  },
  watch: {
    todos: {
      handler(newTodo) {
        localStorage.setItem("todos", JSON.stringify(newTodo));
      },
      deep: true,
    },
  },
  created() {
    const todos = JSON.parse(localStorage.getItem("todos"));
    this.todos = todos ? todos : [];
  },
}).mount("#app");
