// HTTPモジュールの読み込み
const http = require("http");

// ホスト名
const host = "127.0.0.1";

// ポート番号
const port = 3000;

// サーバーオブジェクトを生成
const server = http.createServer((req, res) => {
  // アクセスされたときに実行する処理
  res.setHeader("Content-Type", "text/html");
  res.write("<!DOCTYPE html>");
  res.write('<html lang="ja">');
  res.write("<head>");
  res.write('<meta charset="utf-8">');
  res.write("<title>Hello Node.js</title>");
  res.write("</head>");
  res.write("<body>");
  res.write("<h1>Hello</h1>");
  res.write("<p>Node.js</p>");
  res.write("</body>");
  res.write("</html>");

  const contentType = res.getHeader("Content-Type");
  console.log(contentType);

  res.end();
});

// サーバーを待ち受け状態にする
server.listen(port, host, () => {
  // 待機状態になったら実行する処理
  console.log(`サーバーが立ち上がったぜ！ http://${host}:${port}/`);
});
