// HTTPモジュールの読み込み
const http = require("http");
const fs = require("fs");

// ホスト名
const host = "127.0.0.1";

// ポート番号
const port = 3000;

// サーバーオブジェクトを生成
const server = http.createServer((req, res) => {
  // アクセスされたときに実行する処理
  fs.readFile("sample/chapter03/index.html", "utf-8", (err, data) => {
    if (err) {
      console.log(err.message);
      return;
    }
    res.writeHead(200, { "Content-Type": "text/html" });
    res.write(data);
    res.end();
  });

  const logs = "アクセスがありました";
  fs.writeFile("sample/chapter03/log.text", logs, (err) => {
    if (err) {
      console.log(err.message);
      return;
    }

    console.log("書き込みfinish");
  });
});

// サーバーを待ち受け状態にする
server.listen(port, host, () => {
  // 待機状態になったら実行する処理
  console.log(`サーバーが立ち上がったぜ！ http://${host}:${port}/`);
});
