# =========================================
# macのHomebrewに、
# anyenvとnodenvをインストール
# =========================================

# anyenvのインストール
# -------------------------------

# Homebrew経由でインストール
brew install anyenv

# GitHubからインストール
git clone https://github.com/anyenv/anyenv ~/.anyenv


# anyenvのPathを通す
# -------------------------------

# bashの場合
echo 'export PATH="$HOME/.anyenv/bin:$PATH"' >> ~/.bash_profile
echo 'eval "$(anyenv init -)"' >> ~/.bash_profile

# zshの場合
echo 'export PATH="$HOME/.anyenv/bin:$PATH"' >> ~/.zshrc
echo 'eval "$(anyenv init -)"' >> ~/.zshrc


# シェルの再起動
exec $SHELL -l


# anyenvが使えるかバージョンを確認する
anyenv --version



# nodenvのインストール
# -------------------------------

# env系を入れるためのプラグインをインストール
anyenv install --init

# マニフェストディレクトリを作るか？聞かれるので「y」（yes）を入力して作成する
# Manifest directory doesn't exist: /Users/○○/.config/anyenv/anyenv-install
# Do you want to checkout ? [y/N]:
y

# nodenvをインストール
anyenv install nodenv


# シェルの再起動
exec $SHELL -l



# nodeのインストール
# -------------------------------

# インストール可能なバージョンを表示する
nodenv install -l

# バージョンを指定して Node.js をインストール
nodenv install バージョン番号

# 指定したバージョンをグローバルに設定する
nodenv global バージョン番号

# 指定したバージョンをローカルに設定する（ cd でバージョンを指定するディレクトリに移動してから ）
nodenv local バージョン番号

# インストールされているnodeのリスト
nodenv versions

# Node.jsのバージョン確認
node -v

# Nodeのパッケージマネージャー（npm）のバージョン確認
npm -v
