$.fn.mymodal = function (options) {
  // ここにプラグインの処理

  // オプションの設定
  var settings = $.extend({
    speed: 300
  }, options);

  this.click(function () {
    // body要素内の末尾にdiv要素を追加
    $('body').append('<div class="overlay"></div>');

    // .overlay をフェードイン
    $('.overlay').fadeIn(settings.speed);

    // イベントが発生した要素のhref属性の属性値を取得
    var target = $(this).attr('href');
    // console.log(target);

    // 新たなimg要素を生成
    var largeImg = '<img src="' + target + '" class="content">';

    // .overlay の子要素として追加
    $('.overlay').append(largeImg);

    // body要素に is-active classを追加
    $('body').addClass('is-active');

    // リンク機能を無効化
    return false;
  });

  // 非表示用のクリックイベント
  $('body').on('click', '.overlay', function () {
    // 自身をフェードアウトで非表示にし、コールバック関数発動
    $(this).fadeOut(settings.speed, function () {
      // フェードアウト完了後、自身を削除
      $(this).remove();

      // body要素の is-active classを外す
      $('body').removeClass('is-active');
    });
  });

  return this;
}
