$(function () {
  // スライドコンテンツの数を取得
  var count = $('.js-sliderItem').length;

  // スライドコンテンツの幅を取得
  var slideWidth = $('.js-sliderItem').width();

  // スライドコンテンツを横並びするために必要な幅を計算
  var totalWidth = slideWidth * count;

  // 計算した幅を指定
  $('.js-slider').width(totalWidth);

  // 現在のコンテンツ番号を変数で管理
  var index = 0;

  // 目的のコンテンツまでスライドする関数
  function sliding() {
    // 現在のコンテンツが 「0」より小さいかチェック
    if (index < 0) {
      // 「0」より小さい時
      index = count - 1;
    }

    // 現在のコンテンツが コンテンツの数以上かを確認
    if (index > count - 1) {
      // コンテンツの数より大きい
      index = 0;
    }

    // leftの値をアニメーションで変更
    $('.js-slider').animate({
      left: index * -slideWidth
    }, 300);
  }

  // 自動再生の処理
  var timer = setInterval(function () {
    index++;
    sliding();
  }, 3000);

  // マウスが乗っている時は自動再生を停止
  $('.js-slider').hover(function () {
    // マウスが乗っている時
    clearInterval(timer);
  }, function () {
    // マウスが離れた時
    timer = setInterval(function () {
      index++;
      sliding();
    }, 3000);
  });

  // 「前へ」ボタンが押されたとき
  $('.js-sliderPrevButton').click(function () {
    // 現在のコンテンツ番号に1を引く
    index--;
    sliding();
  });

  // 「次へ」ボタンが押されたとき
  $('.js-sliderNextButton').click(function () {
    // 現在のコンテンツ番号に1を足す
    index++;
    sliding();
  });
});
