class Toggle {
  constructor(selector, target) {
    this.ele = document.querySelector(selector);
    this.target = document.querySelector(target);
    this.objectName = selector.substring(4);

    this.ele.addEventListener('click', this._toggle.bind(this));
  }

  _toggle() {
    const isExpanded = this.ele.getAttribute('aria-expanded') !== 'false';
    this.ele.setAttribute('aria-expanded', !isExpanded);
    this.target.classList.toggle(`is-${this.objectName}Active`);
  }
}

class Toggle2 extends Toggle {
  constructor(selector, target, hiddenTarget) {
    super(selector, target);

    this.hiddenTarget = document.querySelector(hiddenTarget);
  }

  _toggle() {
    super._toggle();
    const isHidden = this.hiddenTarget.getAttribute('aria-hidden') !== 'false';
    this.hiddenTarget.setAttribute('aria-hidden', !isHidden);
  }
}


new Toggle('.js-drawer', 'body');
new Toggle2('.js-popup', 'body', '.js-panel');
