function Toggle(selector, target) {
  this.ele = document.querySelector(selector);
  this.target = document.querySelector(target);
  this.objectName = selector.substring(4);


  this.toggle = function () {
    const isExpanded = this.ele.getAttribute('aria-expanded') !== 'false';
    this.ele.setAttribute('aria-expanded', !isExpanded);
    this.target.classList.toggle(`is-${this.objectName}Active`);
  }

  this.ele.addEventListener('click', this.toggle.bind(this));

};

new Toggle('.js-drawer', 'body');
