<?php
// ファイルの読み込み
  require_once('inc/config.php');

  // 現在のページを取得
  $page = 1; // 初期値
  if ( isset($_GET['page']) && !empty($_GET['page']) ) {
    $page = $_GET['page'];
  }

  // 1ページ辺りの表示件数
  $limit = 5;

  // 並び順
  $sort = 'DESC';
  if ( isset($_GET['sort']) && !empty($_GET['sort']) && $_GET['sort'] === 'ASC') {
    $sort = 'ASC';
  }

  try {
    // データベースへ接続
    $dbh = new PDO(DSN, DB_USER, DB_PASSWORD);

    // エラー発生時に「PDOException」という例外を投げる設定に変更
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQLを作成（Total の件数を取得）
    $sql = 'SELECT count(*) AS total FROM posts';

    // SQLを実行
    $stmt = $dbh->query($sql);

    // 実行結果を連想配列として取得
    $count = $stmt->fetch(PDO::FETCH_ASSOC);

    // トータルが 0 にならない対策
    $total = max($count['total'], 1);

    // トータルページ数
    $total = ceil($total / $limit);

    // $page が存在しないページ番号にならない対策
    $page = max($page, 1);  // 1より小さくならない
    $page = min($page, $total);  // トータルページ数より大きくならない

    // 取得する投稿の開始位置
    $start = ($page - 1) * $limit;

    // SQL作成
    $sql   = 'SELECT p.*, u.name FROM posts AS p JOIN users AS u ON p.user_id = u.id';
    $sql  .= ' ORDER BY created';

    if ($sort === 'DESC') {
      $sql .= ' DESC';
    }

    $sql .= ' LIMIT ?, ?';

    // ステートメント用意
    $stmt = $dbh->prepare($sql);

    // プレースホルダーに値をガッチャンコ
    $stmt->bindValue(1, (int)$start , PDO::PARAM_INT);
    $stmt->bindValue(2, (int)$limit , PDO::PARAM_INT);

    // ステートメントを実行
    $stmt->execute();

    // 実行結果を連想配列として取得
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // データベースとの接続を終了
    $dbh = null;

    // 結果が空じゃないかをチェック
    $flag = false;
    if(!empty($result) ) {
      $flag = true;
    }


    $resposnse = [
      'ok'     => $flag,
      'page'   => $page,
      'total'  => $total,
      'sort'   => $sort,
      'posts'  => $result
    ];
    // print_r($resposnse);
    echo json_encode($resposnse);


  } catch (PDOException $e) {
    //　例外発生時の処理
    echo 'エラー' . h($e->getMessage());
    exit();
  }
