let page = 1;
let sort = "DESC";
let total;

async function getPosts(url) {
  const response = await fetch(url);

  if (response.ok) {
    // OK

    const data = await response.json();

    if (!data.ok) {
      throw new Error("データがないよ");
    }
    return data;
  }
}

async function showPosts(url, reflash = false) {
  try {
    const articles = document.querySelector("#articles");
    const response = await getPosts(url);

    // 設定
    page = response.page;
    sort = response.sort;
    total = response.total;

    // リフレッシュ
    if (reflash) {
      articles.innerHTML = "";
    }

    // テンプレートにセット
    response.posts.forEach((post) => {
      let template = document.querySelector("#template");
      let title = template.content.querySelector("h2");
      let text = template.content.querySelector("p");

      title.innerText = post.title;
      text.innerText = post.content;

      let templateElement = document.importNode(template.content, true);

      articles.appendChild(templateElement);
    });
  } catch (e) {
    console.error(e);
  }
}

showPosts(`post.php?page=${page}`);

document.querySelector(".js-moreButton").addEventListener("click", () => {
  page++;
  if (page <= total) {
    showPosts(`post.php?page=${page}&sort=${sort}`, false);
  }
});

document.querySelector(".js-ascButton").addEventListener("click", () => {
  showPosts(`post.php?page=1&sort=ASC`, true);
});

document.querySelector(".js-descButton").addEventListener("click", () => {
  showPosts(`post.php?page=1&sort=DESC`, true);
});
