const url = 'users.json';

// クエリーをつける場合はエンコードする
// const name = encodeURIComponent("柴田");


// fetch(url)
//   .then(response => response.json())
//   .then(data => {
//     data.forEach(json => {
//       console.log(json.name);
//     });
//   })
//   .catch(err => console.log(`エラー： ${err}`);


// Async Await
// async function getUsers() {
//   const response = await fetch(url);
//   const data = await response.json();
//   data.forEach(json => {
//     console.log(json.name);
//   });
// }
// getUsers();




// POST（JSON）
// async function sendFetch() {
//   const postData = {
//     meg: 'これがとんでいくー'
//   }

//   const param = {
//     method: 'POST',
//     headers: {
//       'Content-Type': 'application/x-www-form-urlencoded',
//       // "Content-Type": "application/json; charset=utf-8"
//     },
//     body: JSON.stringify(postData)
//   }


//   const response = await fetch('test.php', param);
//   const data = await response.json();
//   console.log(data);
// }

// sendFetch();


// POST（Form）
// const form = document.querySelector('.js-form');
// const btn = document.querySelector('.js-btn');

// async function sendFetch() {
//   const param = {
//     method: 'POST',
//     body: new FormData(form)
//   };

//   const response = await fetch('validate.php', param)
//   const data = await response.json();
//   console.log(data);
// }

// btn.addEventListener('click', (e) => {
//   e.preventDefault();
//   sendFetch();

// }, false);




async function getUsers() {
  const response = await fetch(url);
  if (response.ok) {
    const data = await response.json();

    if (!data.length) {
      throw new Error('no data found');
    }

    return data;
  }

}

async function showUsers() {
  try {
    const users = await getUsers();
    users.forEach(user => {
      console.log(user.name);
    });
  } catch (e) {
    console.error(e);
  }
}

showUsers();
