function asyncFunc(time, msg) {

  return new Promise((resolve, reject) => {
    // 管理したい非同期の処理

    setTimeout(() => {

      if (time < 5000) {
        console.log(msg);
        resolve(msg); // 成功の合図
      } else {
        reject(msg); // 失敗の合図
      }

    }, time);
  });
}

// 並列処理
// asyncFunc(2000, '並列で最初に実行')
// asyncFunc(2000, '並列で2回目に実行')
// asyncFunc(1000, '並列で3回目に実行')


// // 並列で処理
Promise.all([asyncFunc(2000, '並列で最初に実行'), asyncFunc(5000, '並列で2回目に実行'), asyncFunc(1000, '並列で3回目に実行')])
  .then(msg => {
    // 全ての非同期処理が終わったあと
    console.log(msg);
  })
  .catch(() => console.log('エラー'));


// 直接で処理
asyncFunc(2000, '直接で最初に実行')
  .then(() => asyncFunc(5000, '直接で2回目に実行'))
  .then(() => asyncFunc(1000, '直接で3回目に実行'))
  .catch(() => console.log('エラー'));
