const btn = document.querySelector('.js-button');

function promiseFunc(url) {

  return new Promise((resolve, reject) => {
    // XHRの作成
    const XHR = new XMLHttpRequest();
    XHR.open('GET', url);
    XHR.send();

    XHR.addEventListener('load', (e) => {
      if (e.target.status === 200) {

        const data = JSON.parse(e.target.responseText);
        resolve(data);


      } else {
        reject();
      }

    });
  });
}

async function asyncFunc() {

  let respose = await promiseFunc('sample.json');
  let title = respose.title;


  respose = await promiseFunc('sample2.json')
  title += respose.title;

  respose = await promiseFunc('sample3.json')
  title += respose.title;


  return title;
}


btn.addEventListener('click', () => {
  asyncFunc()
    .then((title) => {
      document.querySelector('.js-msg').innerText = title;
    })
    .catch(() => console.log('エラーが発生しました'));
});
