const btn = document.querySelector('.js-button');
function asyncFunc(url) {

  return new Promise((resolve, reject) => {
    // XHRの作成
    const XHR = new XMLHttpRequest();
    XHR.open('GET', url);
    XHR.send();

    XHR.addEventListener('load', (e) => {
      if (e.target.status === 200) {
        const data = JSON.parse(e.target.responseText);
        // console.log(data);
        setTimeout(() => {
          document.querySelector('.js-msg').innerText = data.title;
          resolve(); // 成功の合図
        }, 1000);


      } else {
        reject();
      }

    });
  });
}


btn.addEventListener('click', () => {
  asyncFunc('sample.json')
    .then(() => asyncFunc('sample2.json'))
    .then(() => asyncFunc('sample3.json'))
    .catch(() => console.log('エラーが発生しました'));
});
