<?php
  // ファイルの読み込み
  require_once('inc/functions.php');
  require_once('inc/config.php');

  // POSTじゃなかくて、$_POST['answer']が空だったら処理終了
  if ( $_SERVER['REQUEST_METHOD'] !== 'POST' || $_POST['answer'] === '') {
    exit;
  }

  try {
    $dbh = new PDO(DSN, DB_USER, DB_PASSWORD);

    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = 'INSERT INTO poll(answer, created)
             VALUES(?, NOW())';

    $stmt = $dbh->prepare($sql);

    $stmt->bindValue(1, $_POST['answer'], PDO::PARAM_INT);

    $stmt->execute();


    $sql = 'SELECT answer, COUNT(*) AS total FROM poll GROUP BY answer';

    $stmt = $dbh->query($sql);

    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);


    $dbh = null;
  } catch (PDOException $e) {
    echo 'エラー' . h($e->getMessage());
    exit();
  }

echo json_encode( $records );
