<?php
require_once('inc/functions.php');
require_once('inc/config.php');


  $animals = [
    [
       'name' => 'アライグマ',
       'total' => 0
    ],
    [
       'name' => 'アルパカ',
       'total' => 0
    ],
    [
       'name' => 'ウォンバット',
       'total' => 0
    ],
    [
       'name' => '烏骨鶏',
       'total' => 0
    ],
    [
       'name' => 'カピパラ',
       'total' => 0
    ],
  ];

try {
    $dbh = new PDO(DSN, DB_USER, DB_PASSWORD);

    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = 'SELECT answer, COUNT(*) AS total FROM poll GROUP BY answer';

    $stmt = $dbh->query($sql);

    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);


    $dbh = null;
  } catch (PDOException $e) {
    echo 'エラー' . h($e->getMessage());
    exit();
  }

  if (!empty($records)) {
    foreach($records as $record) {
      $animals[$record['answer']]['total'] =  $record['total'];
    }
  }
?>

<!DOCTYPE html>
<html lang="ja">
<head>
  <meta charset="UTF-8">
  <title>投票</title>
  <script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous" defer></script>
  <script src="app.js" defer></script>
</head>
<body>
  <h1>動物人気投票</h1>
  <ul>
    <?php foreach( $animals as $key => $val ) : ?>
    <li>
      <?php echo h($val['name']); ?>
      <span id="poll<?php echo h($key); ?>"><?php echo h($val['total']); ?></span> 票
      <button type="button" class="js-poll" value="<?php echo h($key); ?>">投票</button>
    </li>
    <?php endforeach; ?>
  </ul>
</body>
</html>
